// Funkcija, lai pārbaudītu, vai lietotājs ir pieteicies
function isUserLoggedIn() {
  return document.cookie.includes('loggedIn=true'); // Pārbauda, vai ir saglabāts 'loggedIn=true' sīkdatnēs
}

// Funkcija, kas apstrādā pieteikšanās formu
async function handleLoginFormSubmit(event) {
  event.preventDefault(); // Pārtrauc formu noklusējuma iesniegšanu

  const form = event.target;
  const email = form.email.value; // Iegūst e-pasta vērtību no formas
  const password = form.password.value; // Iegūst paroles vērtību no formas

  try {
    // Nosūta POST pieprasījumu uz login.php ar lietotāja e-pastu un paroli
    const response = await fetch('api/login.php', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ email, password }), // Pārsūta e-pastu un paroli JSON formātā
    });

    const result = await response.json(); // Saņem atbildi JSON formātā

    if (response.ok) {
      console.log('Login successful:', result);

      if (result.redirect) {
        window.location.href = result.redirect; // Ja ir norādīta pāradresācija, pārsūta uz citu lapu
      } else {
        console.error('No redirect URL provided by the server.');
        alert('Login successful, but no redirect URL provided.');
      }
    } else {
      console.error('Login failed:', result.message);
      alert(result.message || 'Login failed. Please try again.');
    }
  } catch (error) {
    console.error('Error during login:', error);
    alert('An unexpected error occurred. Please try again later.');
  }
}

// Funkcija, kas apstrādā reģistrācijas formu
async function handleRegisterFormSubmit(event) {
  event.preventDefault(); // Pārtrauc formu noklusējuma iesniegšanu

  const form = event.target;
  const username = form.username.value; // Iegūst lietotāja vārda vērtību
  const email = form.email.value; // Iegūst e-pasta vērtību
  const password = form.password.value; // Iegūst paroles vērtību
  const confirmPassword = form.confirm_password.value; // Iegūst apstiprinātās paroles vērtību

  if (password !== confirmPassword) {
    alert('Passwords do not match.'); // Ja paroles nesakrīt, parāda brīdinājumu
    return;
  }

  try {
    // Nosūta POST pieprasījumu uz register.php ar reģistrācijas datiem
    const response = await fetch('api/register.php', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ username, email, password }), // Pārsūta reģistrācijas datus JSON formātā
    });

    const result = await response.json(); // Saņem atbildi JSON formātā

    if (response.ok) {
      console.log('Registration successful:', result);
      alert('Registration successful!'); // Ja reģistrācija ir veiksmīga, parāda paziņojumu
      window.location.href = 'homepage.html'; // Pārsūta uz sākumlapu
    } else {
      console.error('Registration failed:', result.message);
      alert(result.message || 'Registration failed. Please try again.');
    }
  } catch (error) {
    console.error('Error during registration:', error);
    alert('An unexpected error occurred. Please try again later.');
  }
}

// Funkcija, kas atjaunina lietotāja interfeisu atkarībā no pieteikšanās stāvokļa
function updateUIBasedOnLoginState() {
  const isLoggedIn = isUserLoggedIn(); // Pārbauda, vai lietotājs ir pieteicies

  if (isLoggedIn) {
    document.querySelector('.logout-button').style.display = 'block'; // Parāda izrakstīšanās pogu
    document.querySelector('.login-button').style.display = 'none'; // Paslēpj pieteikšanās pogu
  } else {
    document.querySelector('.logout-button').style.display = 'none'; // Paslēpj izrakstīšanās pogu
    document.querySelector('.login-button').style.display = 'block'; // Parāda pieteikšanās pogu
  }
}

// Funkcija, kas tiek izsaukta, kad lapa tiek ielādēta
document.addEventListener('DOMContentLoaded', function () {
  updateUIBasedOnLoginState(); // Atjaunina interfeisu atkarībā no pieteikšanās statusa

  const urlParams = new URLSearchParams(window.location.search);
  const productId = urlParams.get('id'); // Iegūst produkta ID no URL parametriem
  const productData = {
    name: 'Rick Owens Sneakers',
    description: 'High-end archival sneakers by Rick Owens.',
    price: '650',
    imageUrl: 'images/rick-owens-sneakers.jpg', 
  };
  if (productId) {
    // Ja produkta ID ir pieejams, parāda produkta datus
    document.getElementById('product-name').textContent = productData.name;
    document.getElementById('product-description').textContent = productData.description;
    document.getElementById('price').textContent = `$${productData.price}`;
    document.getElementById('product-image').src = productData.imageUrl;
  }
});

// Funkcija, kas atjaunina lietotāja profilu
async function updateUserProfile(updateData) {
  try {
    // Nosūta POST pieprasījumu uz update-user-info.php ar lietotāja datiem, kas jāatjaunina
    const response = await fetch('update-user-info.php', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(updateData), // Pārsūta datus JSON formātā
    });

    const result = await response.json(); // Saņem atbildi JSON formātā

    if (response.ok) {
      if (result.success) {
        alert('Profile updated successfully!'); // Ja profils tika veiksmīgi atjaunināts, parāda paziņojumu
      } else {
        alert(result.error || 'Failed to update profile.'); // Ja notika kļūda, parāda kļūdas ziņojumu
      }
    } else {
      console.error('Failed to update profile:', result);
      alert(result.message || 'An error occurred. Please try again.'); // Ja serveris atgriež kļūdu
    }
  } catch (error) {
    console.error('Error updating profile:', error);
    alert('An unexpected error occurred. Please try again later.'); // Ja ir tehniska kļūda
  }
}
